VERSION 5.00
Begin VB.UserControl SRM_Search 
   ClientHeight    =   10800
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   14385
   ScaleHeight     =   10800
   ScaleWidth      =   14385
   Begin VB.Frame Frame1 
      Height          =   9960
      Left            =   0
      TabIndex        =   0
      Top             =   780
      Width           =   14310
      Begin VB.Frame fra_equal 
         Caption         =   "#fra_equal"
         Height          =   1095
         Left            =   0
         TabIndex        =   29
         Top             =   720
         Width           =   4095
         Begin Project1.ArmCombobox cbo_equal 
            Height          =   345
            Left            =   240
            TabIndex        =   30
            Top             =   480
            Width           =   3735
            _ExtentX        =   6588
            _ExtentY        =   609
         End
      End
      Begin VB.TextBox txt_GridFilter 
         Appearance      =   0  'Flat
         BackColor       =   &H0000FFFF&
         BorderStyle     =   0  'None
         Enabled         =   0   'False
         Height          =   495
         Left            =   4200
         MultiLine       =   -1  'True
         TabIndex        =   28
         Top             =   480
         Width           =   10050
      End
      Begin VB.TextBox txt_TvFilters 
         Appearance      =   0  'Flat
         BackColor       =   &H0000FFFF&
         BorderStyle     =   0  'None
         Enabled         =   0   'False
         Height          =   315
         Left            =   4200
         MultiLine       =   -1  'True
         TabIndex        =   27
         Top             =   180
         Width           =   10035
      End
      Begin VB.Frame fra_criteria 
         Caption         =   "#criteria"
         Height          =   8055
         Left            =   0
         TabIndex        =   9
         Tag             =   "fra_criteria"
         Top             =   1860
         Width           =   4095
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria14"
            Height          =   315
            Index           =   14
            Left            =   480
            TabIndex        =   25
            Tag             =   "crit14"
            Top             =   4500
            Width           =   2595
         End
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria13"
            Height          =   315
            Index           =   13
            Left            =   480
            TabIndex        =   24
            Tag             =   "crit13"
            Top             =   4200
            Width           =   2595
         End
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria12"
            Height          =   315
            Index           =   12
            Left            =   480
            TabIndex        =   23
            Tag             =   "crit12"
            Top             =   3900
            Width           =   2595
         End
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria11"
            Height          =   315
            Index           =   11
            Left            =   480
            TabIndex        =   22
            Tag             =   "crit11"
            Top             =   3600
            Width           =   2595
         End
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria10"
            Height          =   315
            Index           =   10
            Left            =   480
            TabIndex        =   21
            Tag             =   "crit10"
            Top             =   3300
            Width           =   2595
         End
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria9"
            Height          =   315
            Index           =   9
            Left            =   480
            TabIndex        =   20
            Tag             =   "crit9"
            Top             =   3000
            Width           =   2595
         End
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria8"
            Height          =   315
            Index           =   8
            Left            =   480
            TabIndex        =   19
            Tag             =   "crit8"
            Top             =   2700
            Width           =   2595
         End
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria7"
            Height          =   315
            Index           =   7
            Left            =   480
            TabIndex        =   18
            Tag             =   "crit7"
            Top             =   2400
            Width           =   2595
         End
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria1"
            Height          =   315
            Index           =   1
            Left            =   480
            TabIndex        =   17
            Tag             =   "crit1"
            Top             =   600
            Width           =   2595
         End
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria2"
            Height          =   315
            Index           =   2
            Left            =   480
            TabIndex        =   16
            Tag             =   "crit2"
            Top             =   900
            Width           =   2595
         End
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria3"
            Height          =   315
            Index           =   3
            Left            =   480
            TabIndex        =   15
            Tag             =   "crit3"
            Top             =   1200
            Width           =   2595
         End
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria4"
            Height          =   315
            Index           =   4
            Left            =   480
            TabIndex        =   14
            Tag             =   "crit4"
            Top             =   1500
            Width           =   2595
         End
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria5"
            Height          =   315
            Index           =   5
            Left            =   480
            TabIndex        =   13
            Tag             =   "crit5"
            Top             =   1800
            Width           =   2595
         End
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria6"
            Height          =   315
            Index           =   6
            Left            =   480
            TabIndex        =   12
            Tag             =   "crit6"
            Top             =   2100
            Width           =   2595
         End
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria0"
            Height          =   315
            Index           =   0
            Left            =   480
            TabIndex        =   11
            Tag             =   "crit0"
            Top             =   300
            Value           =   -1  'True
            Width           =   2595
         End
         Begin VB.OptionButton opt_criteria 
            Caption         =   "#criteria15"
            Height          =   315
            Index           =   15
            Left            =   480
            TabIndex        =   10
            Tag             =   "crit15"
            Top             =   4800
            Width           =   2595
         End
      End
      Begin VB.Frame fra_country 
         Caption         =   "#country"
         Height          =   675
         Left            =   0
         TabIndex        =   7
         Tag             =   "fra_country"
         Top             =   0
         Width           =   4095
         Begin Project1.ArmCombobox cbo_country 
            Height          =   345
            Left            =   120
            TabIndex        =   8
            Top             =   240
            Width           =   3850
            _ExtentX        =   6800
            _ExtentY        =   609
         End
      End
      Begin VB.Frame fra_like 
         Caption         =   "#like"
         Height          =   1035
         Left            =   0
         TabIndex        =   1
         Tag             =   "fra_like"
         Top             =   720
         Width           =   4095
         Begin VB.OptionButton opt_like 
            Caption         =   "#Ended by"
            Height          =   255
            Index           =   2
            Left            =   2640
            TabIndex        =   5
            Tag             =   "like2"
            Top             =   660
            Width           =   1250
         End
         Begin VB.OptionButton opt_like 
            Caption         =   "#Contains"
            Height          =   255
            Index           =   1
            Left            =   1380
            TabIndex        =   4
            Tag             =   "like1"
            Top             =   660
            Width           =   1250
         End
         Begin VB.OptionButton opt_like 
            Caption         =   "#Begin by"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   3
            Tag             =   "like0"
            Top             =   660
            Value           =   -1  'True
            Width           =   1250
         End
         Begin VB.TextBox txt_like 
            Height          =   315
            Left            =   120
            TabIndex        =   2
            Top             =   240
            Width           =   3850
         End
      End
      Begin Project1.ArmGrid grd_search 
         Height          =   8865
         Left            =   4200
         TabIndex        =   6
         Top             =   1050
         Width           =   10065
         _ExtentX        =   17754
         _ExtentY        =   15637
      End
   End
   Begin Project1.ToolbarControl tlb_main 
      Height          =   690
      Left            =   0
      TabIndex        =   26
      Top             =   30
      Width           =   14220
      _ExtentX        =   25083
      _ExtentY        =   1217
   End
End
Attribute VB_Name = "SRM_Search"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK API FUNCTION DECLARES
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Private Declare Function GetTempPath Lib "Kernel32" Alias "GetTempPathA" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long
Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function GetLocaleInfo Lib "Kernel32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK VARIABLES
'**********************************************************************************************************************************
'**********************************************************************************************************************************

#If LIVE = 1 Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

Private ms_Language_Code                As String       'current user interface language
Private ml_U_code                       As Long         'U_Code (GEN_Systems_Users) of logged user
Private ms_LoginName                    As String       'contain loginname
Private mb_InternalInit                 As Boolean      'framework is doing some own control manipulation, all events should handle

Private mb_Initialized                  As Boolean      'framework is initialised or not
Private ms_DecimalSeparator             As String       'locale decimal separator
Private ms_ThousandSeparator            As String       'locale thousand separator

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK CONSTANTS
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

Private Const SCREEN_NAME As String = "SRM_Search"
Private Const LOCALE_USER_DEFAULT = &H400

Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const CL_COLOR_LOCKED As Long = &H80000018
Private Const C_ERRORRAISE As Long = 2500

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK CUSTOM TYPES
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
    InvalidValue = C_ERRORRAISE + 12          ' load function failed ... bad sql
End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301                ' detected row with same unique id
End Enum

'*******************************************************
'SRM_Search specific >>
'*******************************************************

'******** INTERFACE
Private ms_ComponentType As String
Private ms_Country As String
Private ms_SelectedItemCode As String
Private ms_SelectedItemDesc As String
Private ms_SelectedItemFull As String
Private ms_ExternalFilters As String
Private ms_ExternalFiltersDesc As String

'******** Connection Cursor
Private mb_Created As Boolean
Private ms_ConnectString As String
Private ms_UID As String
Private mb_use_framework_connection As Boolean

'******** Stored Procedures
Private ms_ScreenName As String
Private ms_searchProcStoc As String
Private ms_cboCriteriaProcStoc() As String
Private ms_cboCriteriaSearchPrefix() As String

'********
Private mi_nbOfCriteria As Integer
Private mi_DescColIndex As Integer
Private mb_UseOfLike As Boolean
Private mb_UseOfCountry As Boolean
Private mb_UseOfPrint As Boolean
Private mb_UseOfExcelExport As Boolean

'******** Search Criterias
Private ms_filter() As String
'store all the search criterias, even recursive

Private ms_GridFilter As String
Private mb_SelectedData As Boolean
Private mb_txtLike As Boolean

'******** Default values
Private Const MAX_VALUE = 100
Private Const CH_C = "'"

Private Type DefaultValue
    ScreenName As String
    FieldName As String
    CodeValue As String
    DescValue As String
End Type

Private p_DefaultValues(MAX_VALUE) As DefaultValue
Private p_DefaultValuesCount As Integer
'********************************************************
'SRM_Search specific <<
'********************************************************

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK EVENTS
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Public Event quit()

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK PROPERTIES
' please DO NOT change anything in this part of code
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Public Property Let Visible(ByVal aVisible As Boolean)
    UserControl.Extender.Visible = aVisible
End Property

Public Property Get Visible() As Boolean
    Visible = UserControl.Extender.Visible
End Property

Public Property Let Top(ByVal aTop As Single)
    UserControl.Extender.Top = aTop
End Property
Public Property Get Top() As Single
    Top = UserControl.Extender.Top
End Property

Public Property Let Height(ByVal aHeight As Single)
    UserControl.Extender.Height = aHeight
End Property
Public Property Get Height() As Single
    Height = UserControl.Extender.Height
End Property

Public Property Let Left(ByVal aLeft As Single)
    UserControl.Extender.Left = aLeft
End Property
Public Property Get Left() As Single
    Left = UserControl.Extender.Left
End Property

Public Property Let Width(ByVal aWidth As Single)
    UserControl.Extender.Width = aWidth
End Property
Public Property Get Width() As Single
    Width = UserControl.Extender.Width
End Property

Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
    Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight)
End Sub

Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property

Property Let LoginName(as_Login As String)
ms_LoginName = as_Login
End Property

Property Let U_Code(al_Code As Long)
ml_U_code = al_Code
End Property

Property Let Language_Code(AString As String)
ms_Language_Code = AString
End Property

Public Property Set ArmDb(ByRef local_connection As Object)
    If Not (local_connection Is Nothing) Then
        Set mo_Db = local_connection
    End If
End Property

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK METHODS
' please DO NOT change anything in this part of code
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Public Function Load_A_Com() As Boolean

Dim ll_Index As Long
Dim lo_Control As Object

On Error GoTo ErrHandler
    
    Load_A_Com = False
    
    If mb_Initialized Then
        Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    End If
    
    mb_InternalInit = False
    ms_DecimalSeparator = Format(0, ".")
    Dim sBuffer As String
    Dim nBufferLen As Long
    nBufferLen = 255
    sBuffer = String$(nBufferLen, vbNullChar)
    nBufferLen = GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND, sBuffer, nBufferLen)
    If nBufferLen > 0 Then
        ms_ThousandSeparator = Left$(sBuffer, nBufferLen - 1)
    End If
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "ARMPICKER"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "TOOLBARCONTROL"
            lo_Control.Language = ms_Language_Code
            lo_Control.Load_A_Com
        Case "ARMGRID"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "ARMTREEVIEW"
            Set lo_Control.ArmDb = mo_Db
            lo_Control.Language = ms_Language_Code
            Call lo_Control.Load_A_Com
        Case "ARMCHECKVIEW"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "A_CALOCX"
            lo_Control.Language = ms_Language_Code
            Call lo_Control.reinit_cal
        End Select
    Next
    
    'SRM_Search specific
    RefreshFilters
    Call InitControls
    'SRM_Search specific
    
    mb_Initialized = True
    Load_A_Com = True
    Exit Function
ErrHandler:
    Load_A_Com = False
    Call ErrorMessage("Load_A_COM")
End Function

Public Function UnLoad_A_Com() As Boolean
    
On Error GoTo ErrHandler
    
    Dim lo_Control As Object
    
    'add SRM_Search specific
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX", "TOOLBARCONTROL", "ARMGRID", "ARMTREEVIEW", "ARMCHECKVIEW", "ARMPICKER"
            Call lo_Control.UnLoad_A_Com
        End Select
    Next
    
    Set mo_Db = Nothing
    mb_Initialized = False
    UnLoad_A_Com = True
    Exit Function
ErrHandler:
    UnLoad_A_Com = False
    Call ErrorMessage("Unload_A_Com")
End Function



Private Function SqlInt(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlInt = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If Trim(CStr(av_Data)) <> "" Then
        SqlInt = CStr(av_Data)
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlInt")
End Function

Private Function SqlDbl(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDbl = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If Trim(CStr(av_Data)) <> "" Then
        SqlDbl = Str(av_Data)
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlDbl")
End Function

Private Function SqlDate(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDate = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SqlDate = "'" & Format(av_Data, "yyyy-mm-dd") & "'"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlDate")
End Function


Private Function SQLStr(ByVal as_Data As String) As String
On Error GoTo ErrHandler

    SQLStr = "'" & Replace(as_Data, "'", "''") & "'"
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlStr")
End Function

Private Function GetComboKey(ByVal ao_Combo As ArmCombobox) As String
On Error GoTo ErrHandler

    GetComboKey = ""
    If Not (ao_Combo.SelectedItem Is Nothing) Then
        GetComboKey = Trim(CStr(ao_Combo.SelectedItem.Key))
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetComboKey")
End Function

Private Function HasContainer(ByVal lo_Control As Control, ByRef lo_Container As Object) As Boolean
    Dim ll_Index As Long
    Dim lo_Object As Object

    On Error GoTo CleanUp   'not all controls support Container property
    HasContainer = False
    While Not (lo_Control Is Nothing)
        If lo_Control.Container Is lo_Container Then
            HasContainer = True
            Exit Function
        End If
        Set lo_Control = lo_Control.Container
    Wend

CleanUp:

End Function


Private Sub ClearFrame(ByRef ao_Controls As Object, ByVal ao_Frame As Frame)
On Error GoTo ErrHandler

Dim ll_Idx As Long, ll_Count As Long, lo_Control As Object

   mb_InternalInit = True
    ll_Count = ao_Controls.Count - 1
    For ll_Idx = 0 To ll_Count
        Set lo_Control = ao_Controls.Item(ll_Idx)
        
        If StrComp(lo_Control.Name, "chk_Repositioning", vbTextCompare) <> 0 Then
        
            If HasContainer(lo_Control, ao_Frame) Then
                Select Case UCase(TypeName(lo_Control))
                    Case "TEXTBOX"
                        lo_Control.Text = ""
                    Case "ARMCOMBOBOX"
                        Set lo_Control.SelectedItem = Nothing
                    Case "ARMPICKER"
                        Call lo_Control.Clear
                    Case "A_CALOCX"
                        lo_Control.reinit_cal
                    Case "CHECKBOX"
                        lo_Control.value = vbUnchecked
                    Case "ARMCHECKVIEW"
                        Call lo_Control.Init
'                        Call RemoveDroppedCheckItems(lo_Control)
                    Case "FRAME", "LABEL", "TOOLBARCONTROL", "PICTUREBOX", "COMMANDBUTTON", _
                         "TABSTRIP", "DRIVELISTBOX", "DIRLISTBOX", "FILELISTBOX", "LISTVIEW"
                        'do nothing
                    Case "ARMGRID"
                        lo_Control.ClearGrid
                        lo_Control.Requests = ""
                    Case "LISTBOX"
                        lo_Control.ListIndex = -1
                    Case "OPTIONBUTTON"
                        Dim lv_Values As Variant
                        lv_Values = Split(lo_Control.Tag, SEP)
                        If UBound(lv_Values) >= 1 Then
                            lo_Control.value = lv_Values(1)
                        Else
                            lo_Control.value = False
                        End If
                    Case "ARMTREEVIEW"
                        Call lo_Control.Clear
                    Case Else
                        Debug.Print "ClearFrame " & UCase(TypeName(lo_Control))
                End Select
            End If
        End If
    Next
    Set lo_Control = Nothing
    mb_InternalInit = False
    Exit Sub
ErrHandler:
    Set lo_Control = Nothing
    mb_InternalInit = False
    Call ErrorHandler("ClearFrame")
End Sub

Private Sub EnableFrame(ByRef aControls As Variant, ByRef aContainer As Object, ByVal ab_Enabled As Boolean)
On Error GoTo ErrHandler
    
    Dim lIdx As Long, lCount As Long
    Dim lControl As Control
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
        If HasContainer(lControl, aContainer) Then
            Select Case UCase(TypeName(lControl))
                Case "TOOLBARCONTROL"
                    'lControl.Visible = ab_Enabled
                
                Case "FRAME", "LABEL", "MSFLEXGRID"
                    ' Do nothing !
                
                Case "TEXTBOX"
                    lControl.Locked = Not ab_Enabled
                    lControl.BackColor = IIf(ab_Enabled, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
                
                Case "ARMGRID", "TABSTRIP"
                
                Case "ARMCHECKVIEW"
                    If ab_Enabled Then
                        Call lControl.SetVisibleList("EDIT")
                    Else
                        Call lControl.SetVisibleList("VIEW")
                    End If
                    
                Case "DIRLISTBOX", "DRIVELISTBOX", "FILELISTBOX"
                    lControl.Enabled = ab_Enabled
                    lControl.BackColor = IIf(ab_Enabled, CL_COLOR_ENABLED, CL_COLOR_DISABLED)

                Case "LISTVIEW", "COMMANDBUTTON", "ARMCOMBOBOX", "ARMPICKER", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "CHECKBOX"
                    lControl.Enabled = ab_Enabled
                Case Else
                    lControl.Enabled = ab_Enabled
                    Debug.Print "EnableFrame " & UCase(TypeName(lControl))
            End Select
        End If
        Set lControl = Nothing
    Next
    Exit Sub
ErrHandler:
    If Not lControl Is Nothing Then Set lControl = Nothing
    Call ErrorHandler("EnableFrame")
End Sub


' ************************************************************************************
' FRAMEWORK DB-ACCESS FUNCTIONS
' please do not change this code
' ************************************************************************************

' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
#If LIVE = 1 Then
Private Function OpenSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If

On Error GoTo ErrHandler

    Dim lc_Data As Long
    lc_Data = ao_DB.OpenSQL(as_Request)
    
    If lc_Data = 0 Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.RowCount(lc_Data) <> al_RowExpectedCount Then
            Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_DB.RowCount(lc_Data)
        End If
    End If

    OpenSQLSafe = lc_Data

    Exit Function

ErrHandler:

    Call ErrorHandler("OpenSQLSafe")

End Function


' Execute a SQL request returning no data
' Convert SQL runtime errors and process errors to VB Error
' Params:
' ao_Db (Object)
' as_Request (String)
' al_RowAffectedCount (String)
#If LIVE = 1 Then
Private Sub ExecuteSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#End If
On Error GoTo ErrHandler

    ' First execute the request
    If Not ao_DB.ExecuteSQL(as_Request) Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise ArmCusErr.DuplicityDetected, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            Else
                Err.Raise ArmErr.SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            End If
        End If
    End If

    Exit Sub

ErrHandler:
    Call ErrorHandler("ExecuteSQLSafe")
End Sub

Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
On Error GoTo ErrHandler
    
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(mo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetDbError()")
End Function
' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_ErrDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_ErrDescription = Err.Description
    
    Call LogMessage(SCREEN_NAME & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_ErrDescription & ".", "E", False)
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_ErrDescription, , "Error message: " & as_Fct)
    End
End Sub

' logs message to database
Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "E", Optional ab_ExitOnException As Boolean = False)
    Dim ll_errNumber As Long
    Dim ls_ErrDescription As String, ls_ErrSource As String
    
    ll_errNumber = Err.Number
    ls_ErrDescription = Err.Description
    ls_ErrSource = Err.Source

On Error GoTo ErrHandler

Const LOG_REQUEST As String = "EXEC A_log_ins $UCODE$,$LOGTYPE$,$MSG$,$APP$"
    Dim ls_req As String
    Dim ll_Cursor As Long
    Dim ls_Source As String, ls_Msg As String
    
    ls_Source = SCREEN_NAME & " " & App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    ls_Msg = as_logMsg & SEP1 & ll_errNumber & " : " & ls_ErrDescription & " - " & ls_ErrSource
    
    ls_req = Replace(LOG_REQUEST, "$UCODE$", CStr(ml_U_code), , , vbTextCompare)
    ls_req = Replace(ls_req, "$LOGTYPE$", SQLStr(as_logType), , , vbTextCompare)
    ls_req = Replace(ls_req, "$MSG$", Left(Trim(SQLStr(ls_Msg)), 4000), , , vbTextCompare)
    ls_req = Replace(ls_req, "$APP$", Left(Trim(SQLStr(ls_Source)), 50), , , vbTextCompare)
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Err.Number = ll_errNumber
    Err.Description = ls_ErrDescription
    Err.Source = ls_ErrSource
    Exit Sub
    
ErrHandler:
    If ab_ExitOnException Then
        Call MsgBox("A fatal error occured. Unable to log error into database, the application will be close. Please report the following message to your IT support: " & vbCrLf & _
            "Number:" & Err.Number & vbCrLf & "Description:" & Err.Description)
        End
    End If
    Err.Number = ll_errNumber
    Err.Description = ls_ErrDescription
    Err.Source = ls_ErrSource
End Sub


' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
Static ls_ErrDesc As String
Static ls_ErrSource As String
Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
End Sub

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        LockWindowUpdate UserControl.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        UserControl.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    Exit Sub
ErrHandler:
    Call ErrorHandler("LockScreen")
End Sub

Private Function BeginTran(as_Tran As String) As Boolean

On Error GoTo ErrHandler
    BeginTran = False
    ExecuteSQLSafe mo_Db, "BEGIN TRANSACTION " & as_Tran

    BeginTran = True
    Exit Function
    
ErrHandler:
    'try to log error
    Call LogMessage("BeginTran: " & as_Tran)
    Call mo_Db.Disconnect
    Set mo_Db = Nothing
    MsgBox "A Fatal error occured in " & SCREEN_NAME & ".BeginTran, your application will be close. Please contact your IT support"
    End
End Function

Private Function CommitTran(as_Tran As String) As Boolean

On Error GoTo ErrHandler
    CommitTran = False
    ExecuteSQLSafe mo_Db, "COMMIT TRANSACTION " & as_Tran

    CommitTran = True
    Exit Function
    
ErrHandler:
    'try to log error
    Call LogMessage("CommitTran: " & as_Tran)
    Call mo_Db.Disconnect
    Set mo_Db = Nothing
    MsgBox "A Fatal error occured in " & SCREEN_NAME & ".CommitTran, your application will be close. Please contact your IT support"
    End

End Function

Private Function RollbackTran(as_Tran As String) As Boolean
    
    Dim ll_errNumber As Long, ls_ErrSource As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSource = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    RollbackTran = False
    
    ExecuteSQLSafe mo_Db, "ROLLBACK TRANSACTION " & as_Tran


    Err.Number = ll_errNumber
    Err.Source = ls_ErrSource
    Err.Description = ls_ErrDesc

    RollbackTran = True
    Exit Function
    
ErrHandler:
    'try to log error
    Call LogMessage("RollbackTran: " & as_Tran)
    Call mo_Db.Disconnect
    Set mo_Db = Nothing
    MsgBox "A Fatal error occured in " & SCREEN_NAME & ".RollbackTran, your application will be close. Please contact your IT support"
    End
End Function

' ************************************************************************************
' *************************** INTERNATIONAL FUNCTIONS ********************************
' ************************************************************************************

Private Function GetCodePageFromLanguage(ByRef ao_Armdb As Object, ByVal as_Language As String) As Long
On Error GoTo ErrHandler
Const C_REQ As String = "SELECT Code_Page FROM Language WHERE Language_Code = '$Language_Code$'"
    Dim ls_req As String
    Dim ll_Cursor As Long
    Dim ll_codePage As Long
    
    ls_req = Replace(C_REQ, "$Language_Code$", as_Language, , , vbTextCompare)

    ll_Cursor = OpenSQLSafe(ao_Armdb, ls_req)
    Debug.Assert (ll_Cursor <> 0)
    
    ll_codePage = CLng(ao_Armdb.GetFields(ll_Cursor, "Code_Page"))
    Call ao_Armdb.Close(ll_Cursor)
    GetCodePageFromLanguage = ll_codePage
    Exit Function
    
ErrHandler:
    If ll_Cursor <> 0 Then Call ao_Armdb.Close(ll_Cursor)
    Call ErrorHandler("GetCodePageFromLanguage()")
End Function

'convert code page into charset integer
Private Function GetCharSetFromCodePage(ByVal al_CodePage As Long) As Long

On Error GoTo ErrHandler

    Select Case CStr(al_CodePage)
        Case 932 ' Japanese
            GetCharSetFromCodePage = 128
        Case 936 ' Simplified Chinese
            GetCharSetFromCodePage = 134
        Case 949 ' Korean
            GetCharSetFromCodePage = 129
        Case 950 ' Traditional Chinese
            GetCharSetFromCodePage = 136
        Case 1250 ' Eastern Europe
            GetCharSetFromCodePage = 238
        Case 1251 ' Russian
            GetCharSetFromCodePage = 204
        Case 1252 ' Western European Languages
            GetCharSetFromCodePage = 0
        Case 1253 ' Greek
            GetCharSetFromCodePage = 161
        Case 1254 ' Turkish
            GetCharSetFromCodePage = 162
        Case 1255 ' Hebrew
            GetCharSetFromCodePage = 177
        Case 1256 ' Arabic
            GetCharSetFromCodePage = 178
        Case 1257 ' Baltic
            GetCharSetFromCodePage = 186
        Case Else
            GetCharSetFromCodePage = 0
    End Select
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetCharSetFromCodePage()")
End Function

Private Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As Long)

On Error GoTo ErrHandler
   
    Dim lc_Control As Control
    Dim ll_Charset As Long
    
    On Error Resume Next
    ll_Charset = GetCharSetFromCodePage(aCodePage)
    
    For Each lc_Control In ao_Container
        Select Case UCase(TypeName(lc_Control))
        Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
              "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
              "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0", "ARMPICKER"
            lc_Control.Font.Name = "Arial"
            lc_Control.Font.Charset = ll_Charset
        Case "A_SEEK", "A_SRCHTXT"
            lc_Control.Charset = ll_Charset
        End Select
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("ChangeCharset")
End Sub

' Load the labels of a containers
Private Sub LoadLabels(ByRef ao_Armdb As ArmDb, ByRef ao_Container As Object, ByVal as_ScreenName As String, ByVal as_Language As String)
Dim lo_Control As Control   ' A control of the container
Dim li_Idx As Integer, li_Count As Integer
Dim li_Label As Integer      ' A label idx
Dim ls_Request As String
Dim lc_Labels As Long
Dim lsa_ControlTag() As String
    
    On Error GoTo Trace_Err

    ls_Request = "exec screen_csts '" & as_ScreenName & "','" & as_Language & "'"
    lc_Labels = OpenSQLSafe(ao_Armdb, ls_Request)
    
    On Error GoTo WithoutTag
    If ao_Container.Tag <> "" Then
        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", ao_Container.Tag, , 1)
        If li_Label >= 0 Then
            ao_Container.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
        End If
    End If
WithoutTag:
    
    On Error GoTo Trace_Err
    
    ' Iterate the container for loading the label of each element which has defined a tag
    For Each lo_Control In UserControl.Controls
        If HasContainer(lo_Control, ao_Container) Then
            Select Case UCase(TypeName(lo_Control))
                Case UCase("TabStrip") ' Component is a tabstrip, we load the caption of each tab defined
                    Dim lo_Tbs
                    Set lo_Tbs = lo_Control ' Cast for use of intellisense
                    li_Count = lo_Tbs.Tabs.Count
                    For li_Idx = 1 To li_Count
                        If lo_Tbs.Tabs(li_Idx).Tag <> "" Then
                            li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Tbs.Tabs(li_Idx).Tag, , 1)
                            If li_Label >= 0 Then
                                lo_Tbs.Tabs(li_Idx).Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                            End If
                        End If
                    Next
                    Set lo_Tbs = Nothing
                
                Case UCase("ListView") ' Component is a listview, we load the caption of each columns
                    Dim lo_ListView As ListView
                    Set lo_ListView = lo_Control
                    li_Count = lo_ListView.ColumnHeaders.Count
                    For li_Idx = 1 To li_Count
                        If lo_ListView.ColumnHeaders(li_Idx).Tag <> "" Then
                            li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_ListView.ColumnHeaders(li_Idx).Tag, , 1)
                            If li_Label >= 0 Then
                                lo_ListView.ColumnHeaders(li_Idx).Text = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                            End If
                        End If
                    Next
                    Set lo_ListView = Nothing
            
                Case UCase("TextBox")  ' Component is a textbox
                    Dim lo_TextBox As TextBox
                    Set lo_TextBox = lo_Control
                    If lo_TextBox.Tag <> "" Then
                        lsa_ControlTag = Split(lo_Control.Tag, SEP)
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lsa_ControlTag(0), , 1)
                        If li_Label >= 0 Then
                            lo_TextBox.Text = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
                    Set lo_TextBox = Nothing
                
                Case UCase("Label"), UCase("Frame"), UCase("CommandButton"), UCase("CheckBox"), UCase("OptionButton")
                    If lo_Control.Tag <> "" Then
                        lsa_ControlTag = Split(lo_Control.Tag, SEP)
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lsa_ControlTag(0), , 1)
                        If li_Label >= 0 Then
                            lo_Control.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
                Case UCase("ArmGrid")
                    li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag, , 1)
                    If li_Label >= 0 Then
                      Call lo_Control.LoadConstants(ptStatic, ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT"), ctColumns)
                    End If
                    li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag & "_Title", , 1)
                    If li_Label >= 0 Then
                      lo_Control.Title = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                    End If
                Case UCase("Menu")
                    If lo_Control.Name <> "" Then
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Name, , 1)
                        If li_Label >= 0 Then
                            lo_Control.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
            End Select
        End If
    Next
    
    Call mo_Db.Close(lc_Labels)
        
Trace_End:
    Exit Sub
    
Trace_Err:
    If lc_Labels > 0 Then
        Call mo_Db.Close(lc_Labels)
    End If
  
End Sub

Function MsgText(ByVal aID As Long, ByVal aLang As String, ByVal aDefault As String, Optional ByVal aInfo As Variant) As String
On Error GoTo ErrHandler

Const DB_REQ As String = "SELECT message_text FROM error_message WHERE msgid = $id$ AND Language_code = '$lang$'"

    MsgText = ""
    
    Dim lRequest As String
    lRequest = Replace(DB_REQ, "$id$", aID, , , vbTextCompare)
    lRequest = Replace(lRequest, "$lang$", aLang, , , vbTextCompare)
    Dim lData As Long
    
    lData = OpenSQLSafe(mo_Db, lRequest)
    
    Dim lBuffer As String
    lBuffer = mo_Db.GetFields(lData, "message_text")
    mo_Db.Close (lData)
    If lBuffer = "" Then lBuffer = aDefault
    
    Dim li_Idx As Integer
    If Not IsMissing(aInfo) Then
        For li_Idx = 0 To UBound(aInfo)
            lBuffer = Replace(lBuffer, aInfo(li_Idx, 0), aInfo(li_Idx, 1), , , vbTextCompare)
        Next li_Idx
    End If
    
    
    MsgText = lBuffer
    Exit Function
ErrHandler:
    mo_Db.Close (lData)
    Call MsgBox("Connection failure accessing message information.")
    MsgText = aDefault
End Function

'****************************************************************************************
'SRM_Search specific code
'****************************************************************************************

Public Property Get SelectedItemCode() As String
    SelectedItemCode = ms_SelectedItemCode
End Property

Public Property Get SelectedItemDesc() As String
    SelectedItemDesc = ms_SelectedItemDesc
End Property

Public Property Get SelectedItemFull() As String
    SelectedItemFull = ms_SelectedItemFull
End Property

Public Property Get IsDataSelected() As Boolean
    IsDataSelected = mb_SelectedData
End Property

Public Property Let ComponentType(as_componentType As String)
    ms_ComponentType = as_componentType
End Property

Public Function GetTextFromCombo(ByRef ACombo As ArmCombobox) As String
On Error GoTo ErrHandler
 
    If ACombo.Count > 0 And Not ACombo.SelectedItem Is Nothing Then
        GetTextFromCombo = ACombo.SelectedItem.DisplayText
    Else
        GetTextFromCombo = ""
    End If
    Exit Function

ErrHandler:
    Call ErrorMessage("GetTextFromCombo")
End Function

Public Function GetCodeFromCombo(ACombo As ArmCombobox) As String
Dim TheValue As String
On Error GoTo ErrHandler
    
    If ACombo.Count > 0 And Not ACombo.SelectedItem Is Nothing Then
        TheValue = ACombo.SelectedItem.Key
        GetCodeFromCombo = TheValue
    Else
        GetCodeFromCombo = ""
    End If
    
    Exit Function
ErrHandler:
    Call ErrorMessage("GetCodeFromCombo")
End Function

Public Function CorrectCodeStr(ByRef ao_Armdb As Object, ByVal as_Language As String, ByRef ao_AField As ArmCombobox, Optional ab_ARequired As Boolean = False) As String
Dim li_ErrorMessage As Integer
Dim ls_Code As String
Dim ms_DftMessage As String
    
On Error GoTo ErrHandler

    CorrectCodeStr = ""
      
    'Get the code from the combo ("" if no selection)
    ls_Code = GetCodeFromCombo(ao_AField)
    
    'If Field is required
    If ab_ARequired Then
        If ls_Code = "" Then
            li_ErrorMessage = 266
            ms_DftMessage = "#Missing Data in compulsory field"
        End If
    End If
    
    'An error was found
    If li_ErrorMessage <> 0 Then
        MsgBox (MsgText(li_ErrorMessage, as_Language, ms_DftMessage))
        ao_AField.SetFocus
    Else
        CorrectCodeStr = IIf(ls_Code = "", "NULL", CH_C & ls_Code & CH_C)
    End If

    Exit Function
    
ErrHandler:
    Call ErrorMessage("CorrectCodeStr")
End Function

Public Function FormatSqlStringParameter(ByVal as_str As String) As String

On Error GoTo ErrHandler
    
    FormatSqlStringParameter = CH_C & Replace(as_str, CH_C, CH_C & CH_C) & CH_C
    Exit Function
    
ErrHandler:
    FormatSqlStringParameter = False
    Call ErrorMessage("FormatSqlStringParameter")
End Function

Private Function RefreshFilters()
Dim i As Integer

On Error GoTo ErrHandler

    For i = 0 To mi_nbOfCriteria - 1
        ms_filter(i) = ""
    Next i
    
    ms_GridFilter = ""
    txt_GridFilter.Text = ""
    
    opt_like(0).value = True
    opt_criteria(0).value = True
    txt_like.Text = ""
    Set cbo_equal.SelectedItem = Nothing
    grd_search.Visible = False
    
    ms_SelectedItemCode = ""
    ms_SelectedItemDesc = ""
    ms_SelectedItemFull = ""
        
    Exit Function
    
ErrHandler:
    RefreshFilters = False
    Call ErrorMessage("RefreshFilters")
End Function

Private Function LoadToolbars() As Boolean
On Error GoTo ErrHandler
    
Const CL_REQUEST_TB As String = "A_ToolbarDef_sel 1, 2421, 2806, $id$"

    Dim lo_ctrl As Object
    Dim ll_Cursor As Long
    
    ' init toolbar
    Call tlb_main.Load_A_Com
    ' main toolbar
    ll_Cursor = OpenSQLSafe(mo_Db, Replace(CL_REQUEST_TB, "$id$", "NULL"))
    If mo_Db.Find(ll_Cursor, "id", TLB_SRM_SEARCH_ID) >= 0 Then
        Call tlb_main.SetToolbarInfoStringParameters(mo_Db.GetFields(ll_Cursor, "info"), Left(mo_Db.GetFields(ll_Cursor, "info"), 3))
    Else
        Call Err.Raise(ArmErr.InvalidArgument, "mo_Db.Find", "Toolbar id(" & TLB_SRM_SEARCH_ID & ") not found in DB")
    End If
    Call tlb_main.DisplayFace("0")
    Call mo_Db.Close(ll_Cursor)
    LoadToolbars = True
    Exit Function
ErrHandler:
    Call mo_Db.Close(ll_Cursor)
    LoadToolbars = False
    Call ErrorHandler("LoadToolbars()")
End Function

Private Sub InitControls()
Dim i As Integer
    
On Error GoTo ErrHandler
      
    InitBusinessObject
    
    If mb_UseOfCountry = True Then
        fra_country.Visible = True
        cbo_country.FirstBlankItem = False
        cbo_country.Request = "exec Countries_cbo6 '" & ms_Language_Code & "'"
        cbo_country.Load
        cbo_country.SearchItem ms_Country, 0
    Else
        fra_country.Visible = False
    End If
    
    'toolbar
    Call LoadToolbars
    
    tlb_main.ButtonVisible("D") = mb_UseOfPrint
    tlb_main.ButtonVisible("G") = mb_UseOfExcelExport
          
    'option buttons
    For i = 0 To mi_nbOfCriteria - 1
        opt_criteria(i).Visible = True
    Next i
    For i = mi_nbOfCriteria To opt_criteria.Count - 1
        opt_criteria(i).Visible = False
    Next i
    
    'show the good frame
    If ms_cboCriteriaProcStoc(0) <> "" Then
        fra_like.Visible = False
        fra_equal.Visible = True
        cbo_equal.Clear
        cbo_equal.FirstBlankItem = True
        cbo_equal.SearchPrefix = ms_cboCriteriaSearchPrefix(0)
        cbo_equal.Request = ms_cboCriteriaProcStoc(WhichOptIsTrue(opt_criteria, mi_nbOfCriteria - 1))
        mb_UseOfLike = False
    Else
        fra_equal.Visible = False
        fra_like.Visible = True
        mb_UseOfLike = True
    End If
    
    'Default Values
    'SetDefaultValues "SRM_Search"
    'DisplayDefaultValues
    
    txt_TvFilters.Text = ms_ExternalFiltersDesc
    Exit Sub
        
ErrHandler:
    RefreshFilters = False
    Call ErrorMessage("InitControls")
End Sub

Private Sub cbo_equal_ComboItemSelected()
Dim i As Integer
Dim ll_BeginParam As Long
Dim ll_EndParam As Long

On Error GoTo ErrHandler

    Exit Sub
    
ErrHandler:
    LockScreen (False)
    Call ErrorMessage("cbo_equal_ComboItemSelected")
End Sub


Private Sub grd_search_DblClick()
    ValidSelection
    If mb_SelectedData = True Then
        RaiseEvent quit
    End If
End Sub

Private Sub opt_criteria_Click(Index As Integer)
Dim ls_searchProcStoc As String

On Error GoTo ErrHandler

    LockScreen (True)
    
    If ms_cboCriteriaProcStoc(Index) <> "" Then
        mb_txtLike = False
        fra_like.Visible = False
        fra_equal.Visible = True
        cbo_equal.Clear
        cbo_equal.FirstBlankItem = True
        cbo_equal.SearchPrefix = ms_cboCriteriaSearchPrefix(Index)
        ls_searchProcStoc = ms_cboCriteriaProcStoc(WhichOptIsTrue(opt_criteria, mi_nbOfCriteria - 1))
        cbo_equal.Request = ls_searchProcStoc
        mb_UseOfLike = False
        
        If ms_filter(Index) <> "" Then
            cbo_equal.Load
            cbo_equal.SearchItem ms_filter(Index), 0
        End If
        cbo_equal.SetFocus
    Else
        mb_txtLike = True
        fra_equal.Visible = False
        fra_like.Visible = True
        mb_UseOfLike = True
        
        opt_like(0).Visible = True
        opt_like(1).Visible = True
        opt_like(2).Visible = True

        txt_like.Text = Replace(ms_filter(Index), "%", "")
        txt_like.SelStart = 0
        txt_like.SelLength = Len(txt_like.Text)
        
        DoEvents
        If mb_txtLike Then
            txt_like.SetFocus
        Else
            cbo_equal.SetFocus
        End If
    End If
    LockScreen (False)
    Exit Sub
    
ErrHandler:
    LockScreen (False)
    Call ErrorMessage("opt_criteria_Click")
End Sub

Private Sub tlb_Main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    
    LockScreen (True)

    Select Case as_Role
    Case "H"
        ValidSelection
        If mb_SelectedData = True Then
            RaiseEvent quit
        End If
    Case "M"
        FindData
    Case "I"
        RefreshFilters
        grd_search.Visible = False
    Case "T"
        mb_SelectedData = False
        RaiseEvent quit
        
    Case "G"
        'ExcelExport
        'If grd_search.Rows <> 0 Then ExportExcel mo_ArmDb, mb_use_framework_connection, ms_ConnectString, m_Language, grd_search, ms_ComponentType

    Case "D"
        'Print
        If grd_search.SelectedCount = 0 Then
            MsgBox (MsgText(921, as_Language, "#Please, select a line"))
        Else
            'Report mo_ArmDb, mb_use_framework_connection, ms_ConnectString, m_Language, grd_search, ms_ComponentType
        End If

    End Select
    
    LockScreen (False)
    Exit Sub
    
ErrHandler:
    LockScreen (False)
    Call ErrorMessage("tlb_Main_action")
End Sub

Private Sub ValidSelection()
    
On Error GoTo ErrHandler

    If grd_search.Rows = 0 Then Exit Sub

    If grd_search.Row < 0 Then
        MsgBox (MsgText(921, ms_Language_Code, "#Please, select a line"))
        Exit Sub
    End If

    ms_SelectedItemCode = grd_search.CurrentKey(0)
    ms_SelectedItemDesc = grd_search.CurrentLine(mi_DescColIndex)
    
    If ms_SelectedItemCode = "" Then
        MsgBox (MsgText(921, ms_Language_Code, "#Please, select a line"))
        Exit Sub
    End If
    
    Dim ll_Idx As Long, ll_Count As Long
    Dim lv_Buffer As Variant
    ll_Count = grd_search.Cols - 1
    ReDim lv_Buffer(ll_Count)
    For ll_Idx = 0 To ll_Count
        lv_Buffer(ll_Idx) = grd_search.Columns(ll_Idx).Name & SEP1 & grd_search.CurrentLine(grd_search.Columns(ll_Idx).Name)
    Next
    ms_SelectedItemFull = Join(lv_Buffer, SEP)
        
    mb_SelectedData = True

    Exit Sub
    
ErrHandler:
    Call ErrorHandler("ValidSelection()")
End Sub

Private Sub FindData(Optional ab_NotFind As Boolean = False)
Dim ls_searchProcStoc As String
Dim ls_filter As String
Dim ls_Like As String
Dim ls_OptFilter As String
Dim ls_ParamFilter As String
Dim ls_GridFilter As String
Dim ll_BeginParam As Long
Dim ll_EndParam As Long

On Error GoTo ErrHandler

    ls_searchProcStoc = ms_searchProcStoc
    
    ls_OptFilter = opt_criteria(WhichOptIsTrue(opt_criteria, mi_nbOfCriteria)).Caption
    ls_GridFilter = "(" & ls_OptFilter
    'store the present search criteria
    
    If fra_like.Visible = True Then
        If mb_UseOfLike = True Then
            Select Case WhichOptIsTrue(opt_like, 2)
                Case 0:
                    ls_filter = SQLStr(txt_like.Text & "%")
                Case 1:
                    ls_filter = SQLStr("%" & txt_like.Text & "%")
                Case 2:
                    ls_filter = SQLStr("%" & txt_like.Text)
            End Select
        Else
            ls_filter = SQLStr(txt_like.Text)
        End If
            
        ls_ParamFilter = opt_like(WhichOptIsTrue(opt_like, 2)).Caption & " " & SQLStr(txt_like.Text)
        ls_GridFilter = ls_GridFilter & " " & ls_ParamFilter & ")"
        
    Else
        ls_ParamFilter = " = " & " """ & GetTextFromCombo(cbo_equal) & """"
        ls_GridFilter = ls_GridFilter & " " & ls_ParamFilter & ")"
        ls_filter = GetCodeFromCombo(cbo_equal)
    End If
    ms_filter(WhichOptIsTrue(opt_criteria, mi_nbOfCriteria)) = ls_filter
    
    'replace all $$ in the query
    If ReplaceInString(ls_searchProcStoc) = False Then
        Exit Sub
    End If
    
    'load Grid with this query
    If ms_GridFilter = "" Then
        ms_GridFilter = ls_GridFilter
    Else
        ll_BeginParam = InStr(1, ms_GridFilter, ls_OptFilter, vbTextCompare)
        If ll_BeginParam = 0 Then
            ms_GridFilter = ms_GridFilter & " & " & ls_GridFilter
        Else
            ll_BeginParam = ll_BeginParam + Len(ls_OptFilter)
            ll_EndParam = InStr(ll_BeginParam, ms_GridFilter, ")", vbTextCompare)
            ms_GridFilter = Mid(ms_GridFilter, 1, ll_BeginParam) & ls_ParamFilter & Mid(ms_GridFilter, ll_EndParam, Len(ms_GridFilter) - ll_EndParam + 1)
        End If
    End If
    txt_GridFilter.Text = ms_GridFilter
    
    If ab_NotFind = True Then Exit Sub
        
    grd_search.Visible = True
    grd_search.Requests = ls_searchProcStoc
    If grd_search.Execute = False Then
        'If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError grd_search.ArmDb, "SeekForm:FindData", "Requests=", grd_search.Requests
    End If
    
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("FindData()")
End Sub

Private Function ReplaceInString(as_searchproc As String)
Dim li_Idx As Integer
Dim ls_CorrectedCode As String

On Error GoTo ErrHandler

    'replace the $$ in the query
    If mb_UseOfCountry = True Then
        ls_CorrectedCode = CorrectCodeStr(mo_Db, ms_Language_Code, cbo_country, False)
        If ls_CorrectedCode <> "" Then
            as_searchproc = Replace(as_searchproc, "$CT_Code$", ls_CorrectedCode)
        Else
            ReplaceInString = False
            Exit Function
        End If
    End If
    
    as_searchproc = Replace(as_searchproc, "$lang$", "'" & ms_Language_Code & "'")
    For li_Idx = 0 To mi_nbOfCriteria - 1
        If ms_filter(li_Idx) <> "" Then
            as_searchproc = Replace(as_searchproc, "$" & CStr(li_Idx) & "$", ms_filter(li_Idx))
        Else
            as_searchproc = Replace(as_searchproc, "$" & CStr(li_Idx) & "$", "NULL")
        End If
    Next li_Idx
    
    ReplaceInString = True
    Exit Function
    
ErrHandler:
    ReplaceInString = False
    Call ErrorHandler("ReplaceInString()")
End Function

Private Function WhichOptIsTrue(ByRef ao_opt As Object, ai_maxIndex As Integer) As Integer
Dim i As Integer
    
On Error GoTo ErrHandler
    
    For i = 0 To ai_maxIndex
        If ao_opt(i).value = True Then
            WhichOptIsTrue = i
            Exit Function
        End If
    Next i
    WhichOptIsTrue = 0
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("WhichOptIsTrue()")
End Function

Private Sub InitBusinessObject()
Dim la_Columns() As String
    
On Error GoTo ErrHandler
    
    grd_search.MultiSelect = True
    
    mb_UseOfCountry = True
    mb_UseOfPrint = False
    mb_UseOfExcelExport = False
    
    Select Case ms_ComponentType
    Case SRM_CompType.SRCT_contact
    
        ReDim la_Columns(9)
        
        'Criteria : LastName / FirstName / Phone / Mobil / Fax / Email / Role
        ms_ScreenName = "SRM_Search_VendorContact"
        mb_UseOfCountry = False
        
        ms_searchProcStoc = "exec SRM_Search_VendorContact $Language_Code$, $0$, $1$, $2$, $3$, $4$, $5$, $6$, $Drop_Flag$"
               
        ms_searchProcStoc = Replace(ms_searchProcStoc, "$Language_Code$", "'" & ms_Language_Code & "'")
        ms_searchProcStoc = Replace(ms_searchProcStoc, "$Drop_Flag$", GetExternalFilterValue("Drop_Flag"))
        ms_searchProcStoc = Replace(ms_searchProcStoc, "''", "NULL")
        
        SetNbOfCriteria 7
        mi_DescColIndex = 1
        
        la_Columns(0) = "SVC_Id" & SEP & "0" & SEP & "1" & SEP & "SVC_Id" & SEP & "SVC_Id"
        la_Columns(1) = "LastName" & SEP & "2000" & SEP & "0" & SEP & "Lastname" & SEP & "Last Name"
        la_Columns(2) = "FirstName" & SEP & "1000" & SEP & "0" & SEP & "Firstname" & SEP & "First Name"
        la_Columns(3) = "TelOffice" & SEP & "1300" & SEP & "0" & SEP & "TelOffice" & SEP & "Phone"
        la_Columns(4) = "TelMobile" & SEP & "1000" & SEP & "0" & SEP & "TelMobile" & SEP & "Mobil"
        la_Columns(5) = "TelFax" & SEP & "1500" & SEP & "0" & SEP & "TelFax" & SEP & "Fax"
        la_Columns(6) = "Email" & SEP & "1200" & SEP & "0" & SEP & "Email" & SEP & "Email"
        la_Columns(7) = "TIT_desc" & SEP & "0" & SEP & "0" & SEP & "TIT_desc" & SEP & "#Titl" & SEP & "String" & SEP & "" & SEP & "Left"
        la_Columns(8) = "SCR_Desc" & SEP & "0" & SEP & "0" & SEP & "SCR_Desc" & SEP & "#Role" & SEP & "String" & SEP & "" & SEP & "Left"
        la_Columns(9) = "Drop_Flag" & SEP & "0" & SEP & "0" & SEP & "Drop_Flag" & SEP & "#Droped" & SEP & "String" & SEP & "" & SEP & "Left"

        grd_search.SetColumns la_Columns
        
        ms_cboCriteriaProcStoc(6) = "exec SRM_Search_VendorContact_Roles_cbo '" & ms_Language_Code & "'"
        ms_cboCriteriaSearchPrefix(6) = " "
        
        'screen_csts
        LoadLabels mo_Db, Me, ms_ScreenName, ms_Language_Code
        
        grd_search.LoadConstants ptSQL, "EXEC screen_csts_lst2 '" & ms_ScreenName & "' , 'grid', '" & ms_Language_Code & "'", ctColumns
        
        
    Case SRM_CompType.SRCT_Vendor
    
        ReDim la_Columns(13)
        
        'Criteria : Name / Addr1 / Addr2 / Town / Zip / Phone / Fax
        ms_ScreenName = "SRM_Search_Vendor"
        ms_searchProcStoc = "exec SRM_Search_Vendor $CT_Code$, $Language_Code$, $Created_After$, $Created_Before$, $EXCL_SUPERVENDORS$, $MFGP_CODE$, $0$, $1$, $2$, $3$, $4$, $Drop_Flag$"
          
        ms_searchProcStoc = Replace(ms_searchProcStoc, "$Language_Code$", "'" & ms_Language_Code & "'")
        ms_searchProcStoc = Replace(ms_searchProcStoc, "$Created_After$", "'" & GetExternalFilterValue("Created_After") & "'")
        ms_searchProcStoc = Replace(ms_searchProcStoc, "$Created_Before$", "'" & GetExternalFilterValue("Created_Before") & "'")
        ms_searchProcStoc = Replace(ms_searchProcStoc, "$Drop_Flag$", "'" & GetExternalFilterValue("Drop_Flag") & "'")
        ms_searchProcStoc = Replace(ms_searchProcStoc, "$EXCL_SUPERVENDORS$", "'" & GetExternalFilterValue("EXCL_SUPERVENDORS") & "'")
        ms_searchProcStoc = Replace(ms_searchProcStoc, "$MFGP_CODE$", "'" & GetExternalFilterValue("MFGP_CODE") & "'")
        ms_searchProcStoc = Replace(ms_searchProcStoc, "''", "NULL")
        
        
        SetNbOfCriteria 5
        mi_DescColIndex = 1
        
        la_Columns(0) = "SV_Id" & SEP & "0" & SEP & "1" & SEP & "SV_Id" & SEP & "SV_Id"
        la_Columns(1) = "SV_Name" & SEP & "3500" & SEP & "0" & SEP & "SV_Name" & SEP & "Name"
        la_Columns(2) = "SV_City" & SEP & "2000" & SEP & "0" & SEP & "SV_City" & SEP & "City"
        la_Columns(3) = "SV_Zip" & SEP & "1000" & SEP & "0" & SEP & "SV_Zip" & SEP & "Zip"
        la_Columns(4) = "CURR_Code" & SEP & "0" & SEP & "0" & SEP & "CURR_Code" & SEP & "CURR_Code"
        la_Columns(5) = "CURR_Desc" & SEP & "0" & SEP & "0" & SEP & "CURR_Desc" & SEP & "CURR_Desc"
        la_Columns(6) = "CT_Code" & SEP & "0" & SEP & "0" & SEP & "CT_Code" & SEP & "CT_Code"
        la_Columns(7) = "CT_Desc" & SEP & "0" & SEP & "0" & SEP & "CT_Desc" & SEP & "CT_Desc"
        la_Columns(8) = "MFGP_Code" & SEP & "0" & SEP & "0" & SEP & "MFGP_Code" & SEP & "MFGP_Code"
        la_Columns(9) = "MFGP_name" & SEP & "0" & SEP & "0" & SEP & "MFGP_name" & SEP & "MFGP_name"
        la_Columns(10) = "SV_Id_Parent" & SEP & "0" & SEP & "0" & SEP & "SV_Id_Parent" & SEP & "SV_Id_Parent"
        la_Columns(11) = "SV_Master" & SEP & "0" & SEP & "0" & SEP & "SV_Master" & SEP & "SV_Master"
        la_Columns(12) = "SVCS_Id" & SEP & "0" & SEP & "0" & SEP & "SVCS_Id" & SEP & "SVCS_Id"
        la_Columns(13) = "SVCS_Desc" & SEP & "0" & SEP & "0" & SEP & "SVCS_Desc" & SEP & "SVCS_Desc"
        
        grd_search.SetColumns la_Columns
                
        'screen_csts
        LoadLabels mo_Db, Me, ms_ScreenName, ms_Language_Code
        
        grd_search.LoadConstants ptSQL, "EXEC screen_csts_lst2 '" & ms_ScreenName & "' , 'grid', '" & ms_Language_Code & "'", ctColumns
        
    Case SRM_CompType.SRCT_User
    
        ReDim la_Columns(4)
        
        'Criteria : Firstname / Lastname / Phone / Email
        ms_ScreenName = "SRM_Search_User"
        
        mb_UseOfCountry = False
        
        ms_searchProcStoc = "exec SRM_Search_User '', $0$, $1$, $2$, $3$, $Drop_Flag$"
        
        ms_searchProcStoc = Replace(ms_searchProcStoc, "$Drop_Flag$", "'" & GetExternalFilterValue("Drop_Flag") & "'")
        ms_searchProcStoc = Replace(ms_searchProcStoc, "''", "NULL")
                
        SetNbOfCriteria 4
        mi_DescColIndex = 1
        
        la_Columns(0) = "U_Code" & SEP & "0" & SEP & "1" & SEP & "U_Code" & SEP & "U_Code"
        la_Columns(1) = "P_Name" & SEP & "2000" & SEP & "0" & SEP & "P_Name" & SEP & "Surname"
        la_Columns(2) = "P_First_Name" & SEP & "2000" & SEP & "0" & SEP & "P_First_Name" & SEP & "First Name"
        la_Columns(3) = "U_work_phone" & SEP & "2000" & SEP & "0" & SEP & "U_work_phone" & SEP & "Work Phone"
        la_Columns(4) = "U_Email_Armstrong" & SEP & "2000" & SEP & "0" & SEP & "U_Email_Armstrong" & SEP & "Email"
        
        grd_search.SetColumns la_Columns
                        
        'screen_csts
        LoadLabels mo_Db, Me, ms_ScreenName, ms_Language_Code
        
        grd_search.LoadConstants ptSQL, "EXEC screen_csts_lst2 '" & ms_ScreenName & "' , 'grid', '" & ms_Language_Code & "'", ctColumns
        
   Case SRM_CompType.SRCT_product
   
        ReDim la_Columns(6)
        
        'Criteria :
        ms_ScreenName = "SRM_Search_Product"
        ms_searchProcStoc = "exec SRM_Search_Product $Language_Code$, $plant_id$, $SPCS_Id$, $0$, $1$, $Drop_Flag$"
        
        mb_UseOfCountry = False
        
        ms_searchProcStoc = Replace(ms_searchProcStoc, "$Language_Code$", "'" & ms_Language_Code & "'")
        ms_searchProcStoc = Replace(ms_searchProcStoc, "$plant_id$", "'" & GetExternalFilterValue("MFGP_code") & "'")
        ms_searchProcStoc = Replace(ms_searchProcStoc, "$SPCS_Id$", GetExternalFilterValue("SPCS_Id"))
        ms_searchProcStoc = Replace(ms_searchProcStoc, "$Drop_Flag$", "'" & GetExternalFilterValue("Drop_Flag") & "'")
        ms_searchProcStoc = Replace(ms_searchProcStoc, "''", "NULL")
        ms_searchProcStoc = Replace(ms_searchProcStoc, ", ,", ",NULL,")
       
        SetNbOfCriteria 2
        mi_DescColIndex = 2
        
        la_Columns(0) = "SP_Id" & SEP & "0" & SEP & "1" & SEP & "SP_Id" & SEP & "SP_Id"
        la_Columns(1) = "SP_Ref" & SEP & "1500" & SEP & "2" & SEP & "SP_Ref" & SEP & "Product"
        la_Columns(2) = "Product_Desc" & SEP & "4000" & SEP & "2" & SEP & "Product_Desc" & SEP & "Description"
        la_Columns(3) = "MFGP_Code" & SEP & "0" & SEP & "0" & SEP & "MFGP_Code" & SEP & "MFGP_Code"
        la_Columns(4) = "MFGP_name" & SEP & "0" & SEP & "0" & SEP & "MFGP_name" & SEP & "MFGP_name"
        la_Columns(5) = "SPCS_Id" & SEP & "0" & SEP & "0" & SEP & "SPCS_Id" & SEP & "SPCS_Id"
        la_Columns(6) = "SPCS_Desc" & SEP & "0" & SEP & "0" & SEP & "SPCS_Desc" & SEP & "SPCS_Desc"
        
        grd_search.SetColumns la_Columns
                        
        'screen_csts
        LoadLabels mo_Db, Me, ms_ScreenName, ms_Language_Code
        grd_search.LoadConstants ptSQL, "EXEC screen_csts_lst2 '" & ms_ScreenName & "' , 'grid', '" & ms_Language_Code & "'", ctColumns
                        
    End Select
        
    grd_search.Requests = ""

    Exit Sub
    
ErrHandler:
    Call ErrorHandler("InitBusinessObject")
End Sub

Private Sub SetNbOfCriteria(ai_NbOfCriteria As Integer)
    
On Error GoTo ErrHandler

    mi_nbOfCriteria = ai_NbOfCriteria
    ReDim ms_cboCriteriaProcStoc(0 To ai_NbOfCriteria - 1)
    ReDim ms_cboCriteriaSearchPrefix(0 To ai_NbOfCriteria - 1)
    ReDim ms_filter(0 To mi_nbOfCriteria - 1)
    
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("SetNbOfCriteria()")
End Sub

Public Property Let ExternalFilters(ByVal as_Filters As String)
    ms_ExternalFilters = as_Filters
End Property

Public Property Let ExternalFiltersDesc(ByVal as_FiltersDesc As String)
    ms_ExternalFiltersDesc = as_FiltersDesc
End Property

Private Sub txt_like_KeyPress(KeyAscii As Integer)
On Error GoTo ErrHandler

    LockScreen (True)
        
    If KeyAscii = 13 Then
        FindData
    End If
    
    LockScreen (False)
    Exit Sub

ErrHandler:
    LockScreen (False)
    Call ErrorHandler("txt_like_KeyPress()")
End Sub

Private Function GetExternalFilterValue(ByVal as_FilterName As String)
Dim la_ExternalFilters As Variant
Dim ll_Idx As Long

On Error GoTo ErrHandler

    GetExternalFilterValue = ""
    
    la_ExternalFilters = Split(ms_ExternalFilters, SEP)
        
    For ll_Idx = 0 To UBound(la_ExternalFilters) Step 2
        If StrComp(la_ExternalFilters(ll_Idx), as_FilterName, vbTextCompare) = 0 Then
            
            GetExternalFilterValue = la_ExternalFilters(ll_Idx + 1)
            Exit Function
        End If
    Next ll_Idx
        
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetExternalFilterValue")
End Function


